
# Make Scenario — CSV → Captions → Buffer/Hootsuite

This package includes:
- `posts_template.csv` — sample CSV input (datetime_iso, platform, media_url, caption_seed, brand_tone, hashtags, status)
- `make_blueprint_csv_to_captions_to_buffer_hootsuite.json` — importable scenario blueprint (Configure Apps → Import blueprint)
- `AI_Creative_Workflow_OnePager_SOP.pdf` — one-page SOP

## Prerequisites
1. Connect apps: Google Drive, Google Sheets, OpenAI, Buffer, Hootsuite (Make → Connections).
2. Upload `posts_template.csv` to a Drive folder.
3. Create a Google Sheet with sheet `Published` and columns A–F.

## Import
Make → Scenarios → Import blueprint → select the JSON file.

## Configure modules (replace placeholders)
- Module 1 (Watch CSV): set the folder and the file (`posts_template.csv`) OR switch to Google Sheets "Watch rows" if you prefer.
- Module 5 (OpenAI): keep model `gpt-4o-mini` or change to your preferred; no formatting changes needed.
- Module 7 (Buffer): choose your Buffer connection and target profile. Note: Buffer needs a **direct media URL** (no expiring URLs).
- Module 8 (Hootsuite): choose org & profile; assigns media by URL.
- Module 9 (Sheets): set Spreadsheet ID and range.

## CSV columns
- `datetime_iso` — e.g., 2025-09-06T19:00:00+02:00
- `platform` — linkedin | instagram | x
- `media_url` — public URL to MP4/JPG/PNG
- `caption_seed` — short seed idea (the AI will expand per platform)
- `brand_tone` — e.g., professional | friendly
- `hashtags` — space- or comma-separated
- `status` — optional (scheduled/draft)

## How it works
1) Watch & Parse CSV → 2) Iterate rows → 3) OpenAI crafts platform-specific captions + alt text → 4) Router sends to Buffer/Hootsuite → 5) Log scheduled post URL to Google Sheet.

## Tips
- For Instagram, include Reels length (6–20s) in your seed (e.g., "15s reel").
- Add `alt text` to improve accessibility; module 5 returns it in JSON.
- To post simultaneously to multiple platforms, duplicate modules 7/8 with platform filters.
- If you prefer **native scheduling**, replace modules 7/8 with "Create a post" in Meta/LinkedIn/X apps when available in your Make plan.

Generated: 2025-09-04 20:14
